// packetplayer
// oswald berthold 10/2007
// plays IP packets


// init
(
Server.default = s = Server.local;
s.boot;
g = SwingOSC.default;
g.boot;
)

(
~portmax = 2**16-1;
~lenmax = 10**3 * 4;
~packetresp = OSCresponder(nil, "/tcpdump", {
	|t,r,m,a|
	var len, src, dst, sport, dport;
	var h3, h2, hmax;
	h3 = 255**3;
	h2 = 255**2;
	hmax = 2**32-1;
	src = ((h3 * m[2]) + (h2 * m[3]) + (255 * m[4]) + m[5])/hmax;
	dst = ((h3 * m[7]) + (h2 * m[8]) + (255 * m[9]) + m[10])/hmax;
	switch(m[1],
		{1}, {
			"ICMP".postln;
			Synth(\packetICMP);
		},
		{6}, {
			len = m[12]/~lenmax;
			sport = m[6]/~portmax;
			dport = m[11]/~portmax;
			["TCP", len, src, dst, sport, dport].postln;
			Synth(\packetPort, [\plen, len, \src, src, \dst, dst, \sport, sport, \dport, dport, \fbase, 600, \frange, 400]);
		},
		{17}, {
			len = m[12]/~lenmax;
			sport = m[6]/~portmax;
			dport = m[11]/~portmax;
			["UDP", len, src, dst, sport, dport].postln;
			Synth(\packetPort, [\plen, len, \src, src, \dst, dst, \sport, sport, \dport, dport, \fbase, 100, \frange, 400]);
		}
		// missing
		// arp
		// NTPv4
	);
	m.postln;
});
~packetresp.add;
)

~packetresp.remove;

(
// ICMP: very high, 4000-5000 Hz
// protocol ID: 1
SynthDef(\packetICMP, {
	var snd = SinOsc.ar(4000, 0, Linen.kr(Impulse.kr(0), 0.01, 0.1, 0.05, doneAction: 2));
	Out.ar(0, snd);
}).send(s);

// TCP: 
// protocol ID: 6
// merged with UDP
SynthDef(\packetTCP, {
	|plen(1.0), src(0), dst(0), sport(1), dport(1)|
	var fbase = 600;
	var frange = 400;
	var snd = SinOsc.ar(
		Line.ar(sport, dport, plen, frange, fbase, doneAction: 2), // freq
		0, // phase
		Linen.kr(Impulse.kr(0), 0.001, 0.05, plen, doneAction: 2) // amplitude
	);
	Out.ar(0, snd);
}).send(s);

// UDP: bass-line, 60-160 Hz
// protocol ID: 17
SynthDef(\packetPort, { // renamed to Port
	|plen(1.0), src(0), dst(0), sport(1), dport(1), fbase(60), frange(400)|
	//var fbase = 100;
	//var frange = 400;
	var snd = SinOsc.ar(
		Line.ar(sport, dport, plen, frange, fbase, doneAction: 2), // freq
		0, // phase
		Linen.kr(Impulse.ar(0), 0.0001, 0.1, plen, doneAction: 2) // amplitude
	);
	Out.ar(0, Pan2.ar(snd, Line.ar(src, dst, plen)));
}).send(s);

)

x = Synth(\packetUDP);
x = Synth(\packetTCP);
x = Synth(\packetICMP);